//==========================================================
// Game_Skills.js
//==========================================================

//==========================================================
// This script is for the building a management of the items and they're stats
//==========================================================

//==========================================================
// Requires scripts:
// NONE
//==========================================================


//==========================================================
// Variables
//==========================================================
var skillMagic = new Array()
//==========================================================

var blackIcon = LoadImage("\Icons\\Final Fantasy VI - Black Icon.png");
var whiteIcon = LoadImage("\Icons\\Final Fantasy VI - White Icon.png");
var effectIcon = LoadImage("\Icons\\Final Fantasy VI - Effect Icon.png");

//==========================================================
// MAGIC
//==========================================================
{
  function magicObject(name, info, mpCost, type, icon)
  {
    this.name = name;
    this.info = info;
    this.mpCost = mpCost;
    this.type = type;
    this.icon = icon;
    this.learn = 0;
  }
  //==========================================================
  // ATTACK - BLACK
  //==========================================================
  {
  skillMagic[0] = new magicObject("Fire", "Fire-elemental attack", 4, "BLACK", blackIcon);
  skillMagic[1] = new magicObject("Ice", "Ice-elemental attack", 4, "BLACK", blackIcon);
  skillMagic[2] = new magicObject("Bolt", "Lightning-elemental attack", 6, "BLACK", blackIcon);
  skillMagic[3] = new magicObject("Poison", "Poisons an enemy", 3, "BLACK", blackIcon);
  skillMagic[4] = new magicObject("Drain", "Drains HP from an enemy", 15, "BLACK", blackIcon);
  skillMagic[5] = new magicObject("Fire 2", "Fire-elemental attack", 20, "BLACK", blackIcon);
  skillMagic[6] = new magicObject("Ice 2", "Ice-elemental attack", 21, "BLACK", blackIcon);
  skillMagic[7] = new magicObject("Bolt 2", "Lightning-elemental attack", 22, "BLACK", blackIcon);
  skillMagic[8] = new magicObject("Bio", "Poison-elemental attack", 26, "BLACK", blackIcon);
  skillMagic[9] = new magicObject("Fire 3", "Fire-elemental attack", 51, "BLACK", blackIcon);
  skillMagic[10] = new magicObject("Ice 3", "Ice-elemental attack", 52, "BLACK", blackIcon);
  skillMagic[11] = new magicObject("Bolt 3", "Lightning-elemental attack", 53, "BLACK", blackIcon);
  skillMagic[12] = new magicObject("Break", "Turns an enemy to stone", 25, "BLACK", blackIcon);
  skillMagic[13] = new magicObject("Doom", "Dispatches an enemy", 35, "BLACK", blackIcon);
  skillMagic[14] = new magicObject("Pearl", "Pearl-elemental attack", 40, "BLACK", blackIcon);
  skillMagic[15] = new magicObject("Flare", "Barrier-piercing attack", 45, "BLACK", blackIcon);
  skillMagic[16] = new magicObject("Demi", "Cuts an enemy's HP in half", 33, "BLACK", blackIcon);
  skillMagic[17] = new magicObject("Quartr", "Cuts an enemy's HP by 3/4", 48, "BLACK", blackIcon);
  skillMagic[18] = new magicObject("X-Zone", "Sends an enemy into the X-Zone", 53, "BLACK", blackIcon);
  skillMagic[19] = new magicObject("Meteor", "Damages multiple enemies", 62, "BLACK", blackIcon);
  skillMagic[20] = new magicObject("Ultima", "Damages multiple enemies", 80, "BLACK", blackIcon);
  skillMagic[21] = new magicObject("Quake", "Unfocused Earth-elemental attack", 50, "BLACK", blackIcon);
  skillMagic[22] = new magicObject("W Wind", "Unfocused near-fatal attack", 75, "BLACK", blackIcon);
  skillMagic[23] = new magicObject("Merton", "Unfocused piercing fire attack", 85, "BLACK", blackIcon);
  } 
  //==========================================================
  // HEALING - WHITE
  //==========================================================
  {
  skillMagic[24] = new magicObject("Cure", "Recovers HP", 5, "WHITE", whiteIcon);
  skillMagic[25] = new magicObject("Cure 2", "Recovers HP", 25, "WHITE", whiteIcon);
  skillMagic[26] = new magicObject("Cure 3", "Recovers HP", 40, "WHITE", whiteIcon);
  skillMagic[27] = new magicObject("Life", "Recovers life", 30, "WHITE", whiteIcon);
  skillMagic[28] = new magicObject("Life 2", "Recovers life", 60, "WHITE", whiteIcon);
  skillMagic[29] = new magicObject("Antdot", "Cures poisoning", 3, "WHITE", whiteIcon);
  skillMagic[30] = new magicObject("Remedy", "Cures status ailments", 15, "WHITE", whiteIcon);
  skillMagic[31] = new magicObject("Regen", "Gradually recovers HP", 10, "WHITE", whiteIcon);
  skillMagic[32] = new magicObject("Life 3", "Protects from wound", 50, "WHITE", whiteIcon);
  }
  //==========================================================
  // EFFECT
  //==========================================================
  {
  skillMagic[33] = new magicObject("Scan", "Displays an enemy's HP/weak point", 3, "EFFECT", effectIcon);
  skillMagic[34] = new magicObject("Slow", "Slows battle speed", 5, "EFFECT", effectIcon);
  skillMagic[35] = new magicObject("Rasp", "Damages MP", 12, "EFFECT", effectIcon);
  skillMagic[36] = new magicObject("Mute", "Silences target", 8, "EFFECT", effectIcon);
  skillMagic[37] = new magicObject("Safe", "Raises defense", 12, "EFFECT", effectIcon);
  skillMagic[38] = new magicObject("Sleep", "Puts target to sleep", 5, "EFFECT", effectIcon);
  skillMagic[39] = new magicObject("Muddle", "Confuses target", 8, "EFFECT", effectIcon);
  skillMagic[40] = new magicObject("Haste", "Raises battle speed", 10, "EFFECT", effectIcon);
  skillMagic[41] = new magicObject("Stop", "Stops an enemy", 10, "EFFECT", effectIcon);
  skillMagic[42] = new magicObject("Bserk", "Casts berserk on target", 16, "EFFECT", effectIcon);
  skillMagic[43] = new magicObject("Float", "Makes target float", 17, "EFFECT", effectIcon);
  skillMagic[44] = new magicObject("Imp", "Changes to/from \223Imp\224", 10, "EFFECT", effectIcon);
  skillMagic[45] = new magicObject("Rflect", "Casts a Magic barrier on target", 22, "EFFECT", effectIcon);
  skillMagic[46] = new magicObject("Shell", "Raises Magic Defense", 15, "EFFECT", effectIcon);
  skillMagic[47] = new magicObject("Vanish", "Renders target invisible", 18, "EFFECT", effectIcon);
  skillMagic[48] = new magicObject("Haste2", "Speeds up entire party", 38, "EFFECT", effectIcon);
  skillMagic[49] = new magicObject("Slow 2", "Slows multiple enemies", 26, "EFFECT", effectIcon);
  skillMagic[50] = new magicObject("Osmose", "Absorbs MP from an enemy", 1, "EFFECT", effectIcon);
  skillMagic[51] = new magicObject("Warp", "Escapes from dungeons/battles", 20, "EFFECT", effectIcon);
  skillMagic[52] = new magicObject("Quick", "Allows double commands", 99, "EFFECT", effectIcon);
  skillMagic[53] = new magicObject("Dispel", "Maintains poor status", 25, "EFFECT", effectIcon);
  }
  
  var skillSwordTech = [];

  function swordTechObject(name, info)
  {
    this.name = name;
    this.info = info;
  }
  
  //==========================================================
  // SWORD TECHS
  //==========================================================
  {
  skillSwordTech[0] = new swordTechObject("Dispatch", "Single attack");
  skillSwordTech[1] = new swordTechObject("Retort", "Single counter attack");
  skillSwordTech[2] = new swordTechObject("Slash", "Halves an enemy's HP");
  skillSwordTech[3] = new swordTechObject("Quadra Slam", "4-stroke attack");
  skillSwordTech[4] = new swordTechObject("Empowerer", "Absorbs an enemy's HP/MP");
  skillSwordTech[5] = new swordTechObject("Stunner", "Multiple attack/casts 223Stop\224");
  skillSwordTech[6] = new swordTechObject("Quadra Slice", "4-stroke attack");
  skillSwordTech[7] = new swordTechObject("Cleave", "Dices up enemies");
  }
  
  var skillBlitz = [];

  function blitzObject(name, info, image)
  {
    this.name = name;
    this.info = info;
    this.image = CreateSurface(144, 16, CreateColor(0, 0, 0, 0));
    for (var i = 0; i < image.length; i++)
    {
      this.image.blitSurface(image[i], 0 + (i * 8), 0);
    }
  }
  
  //==========================================================
  // BLITZ
  //==========================================================
  {
  var X = LoadImage("Blitz X.png").createSurface();
  var Y = LoadImage("Blitz Y.png").createSurface();
  var R = LoadImage("Blitz R.png").createSurface();
  var L = LoadImage("Blitz L.png").createSurface();
  var Left = LoadImage("Blitz Left.png").createSurface();
  var Up_Left = LoadImage("Blitz Up Left.png").createSurface();
  var Up_Right = LoadImage("Blitz Up Right.png").createSurface();
  var Up = LoadImage("Blitz Up.png").createSurface();
  var Right = LoadImage("Blitz Right.png").createSurface();
  var Down_Left = LoadImage("Blitz Down Left.png").createSurface();
  var Down = LoadImage("Blitz Down.png").createSurface();
  var Down_Right = LoadImage("Blitz Down Right.png").createSurface();
  
  skillBlitz[0] = new blitzObject("Pummel", "Cuts through an enemy's defenses", [Left, Right, Left]);
  
  skillBlitz[1] = new blitzObject("Aura Bolt", "Mystical purity slams an enemy", [Down, Down_Left, Left]);
  
  skillBlitz[2] = new blitzObject("Suplex", "Puts the drop on an enemy", [X, Y, Down, Up]);
  
  skillBlitz[3] = new blitzObject("Fire Dance", "Fire-attack slams enemies", [Left, Down_Left, Down, Down_Right, Right]);
  
  skillBlitz[4] = new blitzObject("Mantra", "Refreshes other party members", [R, L, R, L, X, Y]);
  
  skillBlitz[5] = new blitzObject("Air Blade", "Wind-attack slams enemies", [Up, Up_Right, Right, Down_Right, Down, Down_Left, Left]);

  skillBlitz[6] = new blitzObject("Spiraler", "Recovers party at own expense", [R, L, X, Y, Right, Left]);

  skillBlitz[7] = new blitzObject("Bum Rush", "Srikes a mortal blow", [Left, Up_Left, Up, Up_Right, Right, Down_Right, Down, Down_Left, Left]);
  }
  
  var skillLore = [];

  function loreObject(name, info, mpCost)
  {
    this.name = name;
    this.info = info;
    this.mpCost = mpCost;
  }

  //==========================================================
  // Lore
  //==========================================================
  {
  skillLore[0] = new loreObject("Condemned", "Begins doom countdown", 20);
  skillLore[1] = new loreObject("Roulette", "Begins doom roulette", 10);
  skillLore[2] = new loreObject("CleanSweep", "Water-elemental damage", 30);
  skillLore[3] = new loreObject("Aqua Rake", "Wind/Water elemental damage", 22);
  skillLore[4] = new loreObject("Aero", "Wind-elemental damage", 41);
  skillLore[5] = new loreObject("Blow Fish", "1000 damage", 50);
  skillLore[6] = new loreObject("Big Guard", "Casts Shell/Safe on party", 80);
  skillLore[7] = new loreObject("Revenge", "HP lowering attack", 31);
  skillLore[8] = new loreObject("Pearl Wind", "Uses own HP to heal party", 45);
  skillLore[9] = new loreObject("L.5 Doom", "Casts \223Doom\224 on LV5, 10, 15... enemy", 22);
  skillLore[10] = new loreObject("L.4 Flare", "Casts \223Flare\224 on LV2, 4, 6... enemy", 42);
  skillLore[11] = new loreObject("L.3 Muddle", "Casts \223Muddle\224 on LV3, 6, 9... enemy", 28);
  skillLore[12] = new loreObject("Reflect???", "Status attack on wall-protected enemy", 0);
  skillLore[13] = new loreObject("L.? Pearl", "Pearl attack on LV ? enemy", 50);
  skillLore[14] = new loreObject("Step Mine", "Damage in proportion of # of steps", 34);
  skillLore[15] = new loreObject("Forcefield", "Throws up anti-elemental barrier", 24);
  skillLore[16] = new loreObject("Dischord", "Cuts enemy's level by 1/2", 68);
  skillLore[17] = new loreObject("Sour Mouth", "Inflicts status ailments on an enemy", 32);
  skillLore[18] = new loreObject("Pep Up", "Uses own HP to save the party", 1);
  skillLore[19] = new loreObject("Rippler", "Switches status with an enemy", 66);
  skillLore[20] = new loreObject("Stone", "Damages and muddles an enemy", 22);
  skillLore[21] = new loreObject("Quasar", "Damage pierces enemies' defense", 50);
  skillLore[22] = new loreObject("GrandTrain", "Mortal damage pierces enemies' defense", 64);
  skillLore[23] = new loreObject("Exploder", "Forfeit life to inflict mortal damage", 1);
  }

  var skillRage = [];

  function rageObject(name)
  {
    this.name = name;
    this.info = "";
  }

  //==========================================================
  // Rage
  //==========================================================
  {
  skillRage[0] = new rageObject("Guard");
  skillRage[1] = new rageObject("Soldier");
  skillRage[2] = new rageObject("Templar");
  skillRage[3] = new rageObject("Ninja");
  skillRage[4] = new rageObject("Samurai");
  skillRage[5] = new rageObject("Orog");
  skillRage[6] = new rageObject("Mag Roader");
  skillRage[7] = new rageObject("Retainer");
  skillRage[8] = new rageObject("Hazer");
  skillRage[9] = new rageObject("Dahling");
  skillRage[10] = new rageObject("Rain Man");
  skillRage[11] = new rageObject("Brawler");
  skillRage[12] = new rageObject("Apokryphos");
  skillRage[13] = new rageObject("Dark Force");
  skillRage[14] = new rageObject("Whisper");
  skillRage[15] = new rageObject("Over-Mind");
  skillRage[16] = new rageObject("Osteosaur");
  skillRage[17] = new rageObject("Commander");
  skillRage[18] = new rageObject("Rhodox");
  skillRage[19] = new rageObject("Were-Rat");
  skillRage[20] = new rageObject("Ursus");
  skillRage[21] = new rageObject("Rhinotaur");
  skillRage[22] = new rageObject("Steroidite");
  skillRage[23] = new rageObject("Leafer");
  skillRage[24] = new rageObject("Stray Cat");
  skillRage[25] = new rageObject("Lobo");
  skillRage[26] = new rageObject("Doberman");
  skillRage[27] = new rageObject("Vomammoth");
  skillRage[28] = new rageObject("Fidor");
  skillRage[29] = new rageObject("Baskervor");
  skillRage[30] = new rageObject("Suriander");
  skillRage[31] = new rageObject("Chimera");
  skillRage[32] = new rageObject("Behemoth");
  skillRage[33] = new rageObject("Mesosaur");
  skillRage[34] = new rageObject("Pterodon");
  skillRage[35] = new rageObject("FossilFang");
  skillRage[36] = new rageObject("White Drgn");
  skillRage[37] = new rageObject("Doom Drgn");
  skillRage[38] = new rageObject("Brachosaur");
  skillRage[39] = new rageObject("Tyranosaur");
  skillRage[40] = new rageObject("Dark Wind");
  skillRage[41] = new rageObject("Beakor");
  skillRage[42] = new rageObject("Vulture");
  skillRage[43] = new rageObject("Harpy");
  skillRage[44] = new rageObject("HermitCrab");
  skillRage[45] = new rageObject("Trapper");
  skillRage[46] = new rageObject("Hornet");
  skillRage[47] = new rageObject("Crasshoppr");
  skillRage[48] = new rageObject("Delta Bug");
  skillRage[49] = new rageObject("Gilomantis");
  skillRage[50] = new rageObject("Trilium");
  skillRage[51] = new rageObject("NightShade");
  skillRage[52] = new rageObject("Tumbleweed");
  skillRage[53] = new rageObject("Bloompire");
  skillRage[54] = new rageObject("Trilobiter");
  skillRage[55] = new rageObject("Siegfried");
  skillRage[56] = new rageObject("Nautiloid");
  skillRage[57] = new rageObject("Exocite");
  skillRage[58] = new rageObject("Anguiform");
  skillRage[59] = new rageObject("ReachFrog");
  skillRage[60] = new rageObject("Lizard");
  skillRage[61] = new rageObject("ChickenLip");
  skillRage[62] = new rageObject("Hoover");
  skillRage[63] = new rageObject("Rider");
  skillRage[64] = new rageObject("Chupon");
  skillRage[65] = new rageObject("Pipsqueak");
  skillRage[66] = new rageObject("M-TekArmor");
  skillRage[67] = new rageObject("Sky Armor");
  skillRage[68] = new rageObject("Telstar");
  skillRage[69] = new rageObject("Lethal Wpn");
  skillRage[70] = new rageObject("Vaporite");
  skillRage[71] = new rageObject("Flan");
  skillRage[72] = new rageObject("Ing");
  skillRage[73] = new rageObject("Humpty");
  skillRage[74] = new rageObject("Brainpan");
  skillRage[75] = new rageObject("Cruller");
  skillRage[76] = new rageObject("Cactrot");
	skillRage[77] = new rageObject("Repo Man");
	skillRage[78] = new rageObject("Harvester");
	skillRage[79] = new rageObject("Bomb");
	skillRage[80] = new rageObject("StillLife");
	skillRage[81] = new rageObject("Boxed Set");
	skillRage[82] = new rageObject("SlamDancer");
	skillRage[83] = new rageObject("HadesGigas");
	skillRage[84] = new rageObject("Pug");
	skillRage[85] = new rageObject("Magic Urn");
	skillRage[86] = new rageObject("Mover");
	skillRage[87] = new rageObject("Figaliz");
	skillRage[88] = new rageObject("Buffalax");
	skillRage[89] = new rageObject("Aspix");
	skillRage[90] = new rageObject("Ghost");
	skillRage[91] = new rageObject("Crawler");
	skillRage[92] = new rageObject("Sand Ray");
	skillRage[93] = new rageObject("Areneid");
	skillRage[94] = new rageObject("Actaneon");
	skillRage[95] = new rageObject("Sand Horse");
	skillRage[96] = new rageObject("Dark Side");
	skillRage[97] = new rageObject("Mad Oscar");
	skillRage[98] = new rageObject("Crawly");
	skillRage[99] = new rageObject("Bleary");
	skillRage[100] = new rageObject("Marshal");
	skillRage[101] = new rageObject("Trooper");
	skillRage[102] = new rageObject("General");
	skillRage[103] = new rageObject("Covert");
	skillRage[104] = new rageObject("Ogor");
	skillRage[105] = new rageObject("Warlock");
	skillRage[106] = new rageObject("Madam");
	skillRage[107] = new rageObject("Joker");
	skillRage[108] = new rageObject("Iron Fist");
	skillRage[109] = new rageObject("Goblin");
	skillRage[110] = new rageObject("Apparite");
	skillRage[111] = new rageObject("PowerDemon");
	skillRage[112] = new rageObject("Displayer");
	skillRage[113] = new rageObject("Vector Pup");
	skillRage[114] = new rageObject("Peepers");
	skillRage[115] = new rageObject("Sewer Rat");
	skillRage[116] = new rageObject("Slatter");
	skillRage[117] = new rageObject("Rhinox");
  skillRage[118] = new rageObject("Rhobite");
  skillRage[119] = new rageObject("Wild Cat");
  skillRage[120] = new rageObject("Red Fang");
  skillRage[121] = new rageObject("Bounty Man");
  skillRage[122] = new rageObject("Tusker");
  skillRage[123] = new rageObject("Ralph");
  skillRage[124] = new rageObject("Chitonid");
  skillRage[125] = new rageObject("Wart Puck");
  skillRage[126] = new rageObject("Rhyos");
  skillRage[127] = new rageObject("SrBehemoth");
  skillRage[128] = new rageObject("Vectaur");
  skillRage[129] = new rageObject("Wyvern");
  skillRage[130] = new rageObject("Zombone");
  skillRage[131] = new rageObject("Dragon");
  skillRage[132] = new rageObject("Brontaur");
  skillRage[133] = new rageObject("Allosaurus");
  skillRage[134] = new rageObject("Cirpius");
  skillRage[135] = new rageObject("Sprinter");
  skillRage[136] = new rageObject("Gobbler");
  skillRage[137] = new rageObject("Harpiai");
  skillRage[138] = new rageObject("GloomShell");
  skillRage[139] = new rageObject("Drop");
  skillRage[140] = new rageObject("MindCandy");
  skillRage[141] = new rageObject("WeedFeeder");
  skillRage[142] = new rageObject("Luridan");
  skillRage[143] = new rageObject("ToeCutter");
  skillRage[144] = new rageObject("Over Grunk");
  skillRage[145] = new rageObject("Exoray");
  skillRage[146] = new rageObject("Crusher");
  skillRage[147] = new rageObject("Uroburos");
  skillRage[148] = new rageObject("Primordite");
  skillRage[149] = new rageObject("Sky Cap");
  skillRage[150] = new rageObject("Cephaler");
  skillRage[151] = new rageObject("Maliga");
  skillRage[152] = new rageObject("GiganToad");
  skillRage[153] = new rageObject("Geckorex");
  skillRage[154] = new rageObject("Cluck");
  skillRage[155] = new rageObject("Land Worm");
  skillRage[156] = new rageObject("Test Rider");
  skillRage[157] = new rageObject("PlutoArmor");
  skillRage[158] = new rageObject("Tomb Thumb");
  skillRage[159] = new rageObject("HeavyArmor");
  skillRage[160] = new rageObject("Chaser");
  skillRage[161] = new rageObject("Scullion");
  skillRage[162] = new rageObject("Poplium");
  skillRage[163] = new rageObject("Intangir");
  skillRage[164] = new rageObject("Misfit");
  skillRage[165] = new rageObject("Eland");
  skillRage[166] = new rageObject("Enuo");
  skillRage[167] = new rageObject("Deep Eye");
  skillRage[168] = new rageObject("GreaseMonk");
  skillRage[169] = new rageObject("NeckHunter");
  skillRage[170] = new rageObject("Grenade");
  skillRage[171] = new rageObject("Critic");
  skillRage[172] = new rageObject("Pan Dora");
  skillRage[173] = new rageObject("SoulDancer");
  skillRage[174] = new rageObject("Gigantos");
  skillRage[175] = new rageObject("Mag Roader");
  skillRage[176] = new rageObject("Spek Tor");
  skillRage[177] = new rageObject("Parasite");
  skillRage[178] = new rageObject("EarthGuard");
  skillRage[179] = new rageObject("Coelecite");
  skillRage[180] = new rageObject("Anemone");
  skillRage[181] = new rageObject("Hipocampus");
  skillRage[182] = new rageObject("Spectre");
  skillRage[183] = new rageObject("Evil Oscar");
  skillRage[184] = new rageObject("Slurm");
  skillRage[185] = new rageObject("Latimeria");
  skillRage[186] = new rageObject("StillGoing");
  skillRage[187] = new rageObject("Allo Ver");
  skillRage[188] = new rageObject("Phase");
  skillRage[189] = new rageObject("Outsider");
  skillRage[190] = new rageObject("Barb-e");
  skillRage[191] = new rageObject("ParaSoul");
  skillRage[192] = new rageObject("Pm Stalker");
  skillRage[193] = new rageObject("Hemophyte");
  skillRage[194] = new rageObject("Sp Forces");
  skillRage[195] = new rageObject("Nohrabbit");
  skillRage[196] = new rageObject("Wizard");
  skillRage[197] = new rageObject("Scrapper");
  skillRage[198] = new rageObject("Ceritops");
  skillRage[199] = new rageObject("Commando");
  skillRage[200] = new rageObject("Opinicus");
  skillRage[201] = new rageObject("Poppers");
  skillRage[202] = new rageObject("Lunaris");
  skillRage[203] = new rageObject("Garm");
  skillRage[204] = new rageObject("Vindr");
  skillRage[205] = new rageObject("Kiwok");
  skillRage[206] = new rageObject("Nastidon");
  skillRage[207] = new rageObject("Rinn");
  skillRage[208] = new rageObject("Insecare");
  skillRage[209] = new rageObject("Vermin");
  skillRage[210] = new rageObject("Mantodea");
  skillRage[211] = new rageObject("Bogy");
  skillRage[212] = new rageObject("Prussian");
  skillRage[213] = new rageObject("Black Drgn");
  skillRage[214] = new rageObject("Adamanchyt");
  skillRage[215] = new rageObject("Dante");
  skillRage[216] = new rageObject("Wirey Drgn");
  skillRage[217] = new rageObject("Dueller");
  skillRage[218] = new rageObject("Psychot");
  skillRage[219] = new rageObject("Muus");
  skillRage[220] = new rageObject("Karkass");
  skillRage[221] = new rageObject("Punisher");
  skillRage[222] = new rageObject("Balloon");
  skillRage[223] = new rageObject("Gabbledegak");
  skillRage[224] = new rageObject("GtBehemoth");
  skillRage[225] = new rageObject("Scropion");
  skillRage[226] = new rageObject("ChaosDrgn");
  skillRage[227] = new rageObject("Spit Fire");
  skillRage[228] = new rageObject("Vectagoyle");
  skillRage[229] = new rageObject("Lich");
  skillRage[230] = new rageObject("Osprey");
  skillRage[231] = new rageObject("Mag Roader");
  skillRage[232] = new rageObject("Bug");
  skillRage[233] = new rageObject("Sea Flower");
  skillRage[234] = new rageObject("Fortis");
  skillRage[235] = new rageObject("Abolisher");
  skillRage[236] = new rageObject("Aquila");
  skillRage[237] = new rageObject("Junk");
  skillRage[238] = new rageObject("Mandrake");
  skillRage[239] = new rageObject("1st Class");
  skillRage[240] = new rageObject("Tap Dancer");
  skillRage[241] = new rageObject("Necromancr");
  skillRage[242] = new rageObject("Borras");
  skillRage[243] = new rageObject("Mag Roader")
  skillRage[244] = new rageObject("Wild Rat");
  skillRage[245] = new rageObject("Gold Bear");
  skillRage[246] = new rageObject("Innoc");
  skillRage[247] = new rageObject("Trixter");
  skillRage[248] = new rageObject("Red Wolf");
  skillRage[249] = new rageObject("Didalos");
  skillRage[250] = new rageObject("Woolly");
  skillRage[251] = new rageObject("Veteran");
  skillRage[252] = new rageObject("Sky Base");
  skillRage[253] = new rageObject("IronHitman");
  skillRage[254] = new rageObject("Io");
  }

  var skillDance = [];

  function danceObject(name)
  {
    this.name = name;
    this.info = "";
  }
  
  //==========================================================
  // Dance
  //==========================================================
  {
  skillDance[0] = new danceObject("Wind Song");
  skillDance[1] = new danceObject("Forest Suite");
  skillDance[2] = new danceObject("Desert Aria");
  skillDance[3] = new danceObject("Love Sonata");
  skillDance[4] = new danceObject("Earth Blues");
  skillDance[5] = new danceObject("Water Rondo");
  skillDance[6] = new danceObject("Dusk Requium");
  skillDance[7] = new danceObject("Snowman Jazz");
  }
}